#include "UnityNP.h"

#define CASE_ERROR_TO_STRING(errCode) case (int)errCode: errorString = #errCode; break;

namespace UnityPlugin
{
	ErrorCode TranslateSceError(int sceError)
	{
		switch(sceError)
		{
		case SCE_TOOLKIT_NP_SUCCESS:
			return NP_OK;

		case SCE_TOOLKIT_NP_OFFLINE:
			return NP_ERR_NOT_SIGNED_IN;
		}

		return NP_ERR_FAILED;
	}

	const char* LookupSceErrorCode(int errorCode)
	{
		static char defaultErrorString[16];
		const char* errorString = NULL;

		switch(errorCode)
		{
			// NP Basic Errors...
			CASE_ERROR_TO_STRING(SCE_NP_BASIC_ERROR_UNKNOWN)
			CASE_ERROR_TO_STRING(SCE_NP_BASIC_ERROR_INVALID_ARGUMENT)
			CASE_ERROR_TO_STRING(SCE_NP_BASIC_ERROR_OUT_OF_MEMORY)
			CASE_ERROR_TO_STRING(SCE_NP_BASIC_ERROR_NOT_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_BASIC_ERROR_ALREADY_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_BASIC_ERROR_BUSY)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_WORD_FILTER_NOT_INITIALISED)

			// NP Toolkit Errors.
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_SUCCESS)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_ALREADY_INITIALISED)
			
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_FAILED_ALLOCATE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_FUTURE_IS_IN_USE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_GENERIC_ERRORS)

			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_INIT_ERRORS)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_INIT_INVALID_MEM_MANAGER)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_INIT_START_THREAD)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_INVALID_ARGUMENT)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_INVALID_MODULE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_INVALID_NUM_SESSION_ATTRIBUTES)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_INVALID_POINTER)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_ATTRIBUTES_ALREADY_REGISTERED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_CALLBACK_FAILURE_ERROR)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_FAIL_TO_REGISTER_ATTRIBUTES)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_INVALID_JOIN_DESCRIPTOR)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_INVALID_MODIFY_ATTRIBUTES)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_INVALID_PARAMETERS)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_INVALID_ROOM_ID)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_INVALID_ROOM_MESSAGE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_INVALID_SEARCH_CRITERIA)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_INVALID_SESSION_DESC)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_INVALID_SLOTS_INFORMATION)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_JOIN_FAILED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_LEAVING_FAILED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_NO_SESSION_ACTIVE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_NO_SESSION_TO_JOIN)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_SEARCH_FAILED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_SERVICE_BUSY)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_SESSION_ALREADY_ACTIVE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_SESSION_CREATION_FAILED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_SESSION_DOES_NOT_EXIST)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_SESSION_KICKEDOUT)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_SESSION_ROOM_DESTROYED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MATCHING_SESSION_UPDATE_FAILED)
			
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MESSAGE_ATTACHMENT_INVALID)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MESSAGE_DATA_TOO_LARGE)
			
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MESSAGE_NO_DATA)

			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MESSAGE_TYPE_MISMATCH)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MESSAGE_USER_CANCEL)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_MODULE_NOT_OWNED)

			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_NETWORK_ERROR)
			
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_NOT_INITIALISED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_OFFLINE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_OPERATION_IN_PROGRESS)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_OUT_OF_DISKSPACE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_OUT_OF_MEMORY)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_PRESENCE_DATA_TOO_BIG)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_PRESENCE_NO_TOKENS)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_PRESENCE_STRING_TOO_LONG)
			
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_FRIEND_LIST_EMPTY)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_INVALID_BOARD)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NO_FRIEND_CACHE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NO_FRIEND_RANK)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NO_MATCHING_BOARD)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NO_MATCHING_SCORE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NO_OUTSTANDING)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NO_RANK_IN_READ_CACHE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NO_SCORES)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NOT_HIGH_SCORE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NOT_INITIALISED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_NOT_TERMINATED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_RANGE_INVALID)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_REQUEST_ABORTED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_RANKING_SLOT_FULL)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_SERVICE_ID_NOT_OVERRIDEN)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_SERVICE_NOT_INITIALISED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_SERVICE_OFFLINE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_NOT_REGISTERED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_SNS_ACCESS_TOKEN_ERROR)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_SNS_INVALID_MESSAGE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_SNS_MESSAGE_POST_FAILED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TERMINATED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TERMINATION_NOT_SUPPORTED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_ABORT_FAIL)
			
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_ALREADY_REGISTERED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_BUSY)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_NOT_ENOUGH_SPACE)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_NOT_INITIALISED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_NOT_REGISTERED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_NOT_TERMINATED)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_REGISTERING)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_SETUP_DIALOG_ALREADY_RUNNING)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TROPHY_UPDATE_ERROR)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TSS_NO_DATA)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TUS_NO_DATA)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_TUS_NO_VARS)
			CASE_ERROR_TO_STRING(SCE_TOOLKIT_NP_WORD_FILTER_SLOT_FULL)

			// NP Trophy
			CASE_ERROR_TO_STRING(SCE_NP_TROPHY_ERROR_INVALID_HANDLE)
			CASE_ERROR_TO_STRING(SCE_NP_TROPHY_ERROR_INVALID_CONTEXT)


			// NP Misc
			CASE_ERROR_TO_STRING(SCE_NP_ERROR_ALREADY_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_ERROR_NOT_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_ERROR_INVALID_ARGUMENT)
			CASE_ERROR_TO_STRING(SCE_NP_ERROR_INVALID_STATE)
			CASE_ERROR_TO_STRING(SCE_NP_ERROR_EXPIRED_TICKET)

			CASE_ERROR_TO_STRING(SCE_NP_UTIL_ERROR_INVALID_ARGUMENT)
			CASE_ERROR_TO_STRING(SCE_NP_UTIL_ERROR_INVALID_NP_ID)
			CASE_ERROR_TO_STRING(SCE_NP_UTIL_ERROR_NOT_MATCH)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_ERROR_NOT_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_ERROR_INVALID_ARGUMENT)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_ERROR_ABORTED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_ERROR_INVALID_SIGNATURE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_ERROR_INSUFFICIENT_ARGUMENT)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_ERROR_INVALID_ID)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_ERROR_INVALID_ALIGNMENT)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_BAD_REQUEST)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_FORBIDDEN)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_NO_SUCH_TITLE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_BEFORE_SERVICE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_END_OF_SERVICE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_MAINTENANCE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_TOO_LARGE_DATA)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_USER_NOT_ASSIGNED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_USER_STORAGE_TITLE_MASTER_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_VIRTUAL_USER)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_GAME_RANKING_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_CENSORED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_BOARD_MASTER_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_BEFORE_SERVICE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_END_OF_SERVICE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_MAINTENANCE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMUNITY_SERVER_ERROR_NOT_BEST_SCORE)

			// NP Matching
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_OUT_OF_MEMORY)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_ALREADY_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_NOT_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_CONTEXT_MAX)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_CONTEXT_ALREADY_EXISTS)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_CONTEXT_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_CONTEXT_ALREADY_STARTED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_CONTEXT_NOT_STARTED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_SERVER_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_ARGUMENT)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_CONTEXT_ID)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_SERVER_ID)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_WORLD_ID)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_LOBBY_ID)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_ROOM_ID)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_MEMBER_ID)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_ATTRIBUTE_ID)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_CASTTYPE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_SORT_METHOD)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_MAX_SLOT)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_MATCHING_SPACE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_BLOCK_KICK_FLAG)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_MESSAGE_TARGET)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_RANGE_FILTER_MAX)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INSUFFICIENT_BUFFER)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_DESTINATION_DISAPPEARED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_REQUEST_TIMEOUT)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_ALIGNMENT)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_CONNECTION_CLOSED_BY_SERVER)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_SSL_VERIFY_FAILED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_SSL_HANDSHAKE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_SSL_SEND)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_SSL_RECV)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_JOINED_SESSION_MAX)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_ALREADY_JOINED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_SESSION_TYPE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_NP_SIGNED_OUT)
			
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_SERVER_NOT_AVAILABLE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_NOT_ALLOWED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_ABORTED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_REQUEST_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_SESSION_DESTROYED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_CONTEXT_STOPPED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_REQUEST_PARAMETER)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_NOT_NP_SIGN_IN)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_ROOM_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_ROOM_MEMBER_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_LOBBY_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_LOBBY_MEMBER_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_KEEPALIVE_TIMEOUT)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_TIMEOUT_TOO_SHORT)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_TIMEDOUT)
			//CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_SLOT_GROUP)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_INVALID_ATTRIBUTE_SIZE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_ERROR_CANNOT_ABORT)
			

			// Server Errors
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_BAD_REQUEST)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_SERVICE_UNAVAILABLE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_BUSY)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_END_OF_SERVICE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_INTERNAL_SERVER_ERROR)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_PLAYER_BANNED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_FORBIDDEN)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_BLOCKED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_UNSUPPORTED_NP_ENV)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_INVALID_TICKET)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_INVALID_SIGNATURE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_EXPIRED_TICKET)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_ENTITLEMENT_REQUIRED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_CONTEXT)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_CLOSED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_TITLE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_WORLD)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_LOBBY)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_ROOM)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_LOBBY_INSTANCE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_ROOM_INSTANCE)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_PASSWORD_MISMATCH)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_LOBBY_FULL)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_ROOM_FULL)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_GROUP_FULL)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_USER)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_TITLE_PASSPHRASE_MISMATCH)
			//CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_DUPLICATE_LOBBY)
			//CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_DUPLICATE_ROOM)
			//CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_JOIN_GROUP_LABEL)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_SUCH_GROUP)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NO_PASSWORD)
			//CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_MAX_OVER_SLOT_GROUP)
			//CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_MAX_OVER_PASSWORD_MASK)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_DUPLICATE_GROUP_LABEL)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_REQUEST_OVERFLOW)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_ALREADY_JOINED)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_NAT_TYPE_MISMATCH)
			CASE_ERROR_TO_STRING(SCE_NP_MATCHING2_SERVER_ERROR_ROOM_INCONSISTENCY)

			// Commerce
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_NOT_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_ALREADY_INITIALIZED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_ARGUMENT)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_UNSUPPORTED_VERSION)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_CTX_MAX)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_INDEX)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_SKUID)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_SKU_NUM)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_MEMORY_CONTAINER)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INSUFFICIENT_MEMORY_CONTAINER)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_OUT_OF_MEMORY)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_CTX_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_CTXID_NOT_AVAILABLE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_REQ_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_REQID_NOT_AVAILABLE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_ABORTED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_RESPONSE_BUF_TOO_SMALL)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_COULD_NOT_RECV_WHOLE_RESPONSE_DATA)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_RESULT_DATA)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_UNKNOWN)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_SERVER_MAINTENANCE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_SERVER_UNKNOWN)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INSUFFICIENT_BUF_SIZE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_REQ_MAX)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_TARGET_TYPE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_TARGET_ID)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_INVALID_SIZE)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_ERROR_DATA_NOT_FOUND)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_BAD_REQUEST)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_UNKNOWN_ERROR)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_SESSION_EXPIRED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_ACCESS_PERMISSION_DENIED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_NO_SUCH_CATEGORY)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_NO_SUCH_PRODUCT)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_NOT_ELIGIBILITY)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_INVALID_SKU)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_ACCOUNT_SUSPENDED1)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_ACCOUNT_SUSPENDED2)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_OVER_SPENDING_LIMIT)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_INVALID_VOUCHER)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_VOUCHER_ALREADY_CONSUMED)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SERVER_ERROR_EXCEEDS_AGE_LIMIT_IN_BROWSING)
			CASE_ERROR_TO_STRING(SCE_NP_COMMERCE2_SYSTEM_UTIL_ERROR_INVALID_VOUCHER)

			// Auth
			CASE_ERROR_TO_STRING(SCE_NP_AUTH_EINVAL)
			CASE_ERROR_TO_STRING(SCE_NP_AUTH_ENOMEM)
			CASE_ERROR_TO_STRING(SCE_NP_AUTH_ESRCH)
			CASE_ERROR_TO_STRING(SCE_NP_AUTH_EBUSY)
			CASE_ERROR_TO_STRING(SCE_NP_AUTH_EABORT)
			CASE_ERROR_TO_STRING(SCE_NP_AUTH_EEXIST)
			CASE_ERROR_TO_STRING(SCE_NP_AUTH_EINVALID_ARGUMENT)

			default:
				sprintf(defaultErrorString, "0x%08x", errorCode);
				errorString = defaultErrorString;
				break;
		}

		return errorString;
	}

}	// namespace UnityPlugin
